/*
 * Decompiled with CFR 0.152.
 */
package client.ui;

import java.awt.BasicStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FrmHelp
extends JFrame
implements MouseListener {
    private Toolkit tk = this.getToolkit();
    private PnlButton pnlEquations;
    private PnlButton pnlFlowcharts;
    private CardLayout clayout = new CardLayout(0, 0);
    private JPanel pnlRight;
    private EditorPaneEquations jepEquations;
    private EditorPaneFlowcharts jepFlowcharts;
    JLabel lblTest1;
    JLabel lblTest2;

    public FrmHelp() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("Visual Equation Solver v1.1 - \u0392\u03bf\u03ae\u03b8\u03b5\u03b9\u03b1");
        URL icourl = this.getClass().getResource("/client/ui/images/logo-ico.png");
        Image imgLogoIco = this.tk.getImage(icourl);
        this.setIconImage(imgLogoIco);
        JPanel pnlContainer = (JPanel)this.getContentPane();
        pnlContainer.setPreferredSize(new Dimension(920, 600));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        pnlContainer.setLayout(gbl);
        JPanel pnlLeft = new JPanel(new FlowLayout(0, 0, 0));
        pnlLeft.setPreferredSize(new Dimension(200, 500));
        pnlLeft.setMinimumSize(new Dimension(200, 500));
        pnlLeft.setMaximumSize(new Dimension(200, 500));
        pnlLeft.setBackground(new Color(209, 200, 188));
        JPanel pnlLogo = new JPanel(new FlowLayout(0, 0, 0));
        pnlLogo.setPreferredSize(new Dimension(200, 100));
        pnlLogo.setBackground(Color.gray);
        pnlLogo.setOpaque(false);
        JPanel pnlSpace = new JPanel(new FlowLayout(0, 0, 0));
        pnlSpace.setPreferredSize(new Dimension(200, 25));
        pnlSpace.setOpaque(false);
        pnlLogo.add(pnlSpace);
        URL logourl = this.getClass().getResource("/client/ui/images/logo-width200.png");
        Image imgLogo = this.tk.getImage(logourl);
        JLabel lblLogo = new JLabel(new ImageIcon(imgLogo));
        lblLogo.setPreferredSize(new Dimension(200, 48));
        pnlLogo.add(lblLogo);
        pnlLeft.add(pnlLogo);
        JPanel pnlButtons = new JPanel(new FlowLayout(0, 0, 0));
        pnlButtons.setPreferredSize(new Dimension(200, 400));
        pnlButtons.setBackground(Color.pink);
        pnlButtons.setOpaque(false);
        JPanel pnlLine = new JPanel(new FlowLayout(1, 0, 0));
        pnlLine.setPreferredSize(new Dimension(200, 1));
        pnlLine.setBackground(new Color(35, 43, 46));
        pnlLeft.add(pnlLine);
        this.pnlEquations = new PnlButton("\u039f\u03b9 \u0395\u03be\u03b9\u03c3\u03ce\u03c3\u03b5\u03b9\u03c2 \u0391 \u03ba\u03b1\u03b9 \u0392 \u03b2\u03b1\u03b8\u03bc\u03bf\u03cd", 200, 35);
        this.pnlEquations.addMouseListener(this);
        this.pnlEquations.setBackground(new Color(223, 217, 209));
        this.pnlEquations.setCrn(true);
        pnlLeft.add(this.pnlEquations);
        pnlLine = new JPanel(new FlowLayout(1, 0, 0));
        pnlLine.setPreferredSize(new Dimension(200, 1));
        pnlLine.setBackground(new Color(35, 43, 46));
        pnlLeft.add(pnlLine);
        this.pnlFlowcharts = new PnlButton("\u03a4\u03b1 \u0394\u03b9\u03b1\u03b3\u03c1\u03ac\u03bc\u03bc\u03b1\u03c4\u03b1 \u03a1\u03bf\u03ae\u03c2", 200, 35);
        this.pnlFlowcharts.addMouseListener(this);
        this.pnlFlowcharts.setBackground(new Color(223, 217, 209));
        pnlLeft.add(this.pnlFlowcharts);
        pnlLine = new JPanel(new FlowLayout(1, 0, 0));
        pnlLine.setPreferredSize(new Dimension(200, 1));
        pnlLine.setBackground(new Color(35, 43, 46));
        pnlLeft.add(pnlLine);
        pnlLeft.add(pnlButtons);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 100.0;
        gbc.fill = 3;
        gbl.setConstraints(pnlLeft, gbc);
        pnlContainer.add(pnlLeft);
        this.pnlRight = new JPanel();
        this.pnlRight.setLayout(this.clayout);
        this.pnlRight.setPreferredSize(new Dimension(720, 500));
        this.pnlRight.setMinimumSize(new Dimension(720, 500));
        this.pnlRight.setMaximumSize(new Dimension(720, 500));
        this.pnlRight.setBackground(Color.green);
        JScrollPane jepScroll = new JScrollPane(20, 30);
        this.jepEquations = new EditorPaneEquations();
        jepScroll.getViewport().add(this.jepEquations);
        this.pnlRight.add("equations", jepScroll);
        jepScroll = new JScrollPane(20, 30);
        this.jepFlowcharts = new EditorPaneFlowcharts();
        jepScroll.getViewport().add(this.jepFlowcharts);
        this.pnlRight.add("flowcharts", jepScroll);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        gbl.setConstraints(this.pnlRight, gbc);
        pnlContainer.add(this.pnlRight);
        this.pack();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object src = e.getSource();
        if (src.equals(this.pnlEquations)) {
            this.pnlEquations.setHover(false);
        } else if (src.equals(this.pnlFlowcharts)) {
            this.pnlFlowcharts.setHover(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object src = e.getSource();
        if (src.equals(this.pnlEquations)) {
            this.pnlEquations.setHover(true);
        } else if (src.equals(this.pnlFlowcharts)) {
            this.pnlFlowcharts.setHover(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object src = e.getSource();
        if (src.equals(this.pnlEquations)) {
            this.clayout.show(this.pnlRight, "equations");
            this.pnlEquations.setCrn(true);
            this.pnlFlowcharts.setCrn(false);
        } else if (src.equals(this.pnlFlowcharts)) {
            this.clayout.show(this.pnlRight, "flowcharts");
            this.pnlEquations.setCrn(false);
            this.pnlFlowcharts.setCrn(true);
        }
    }

    class EditorPaneFlowcharts
    extends JEditorPane {
        public EditorPaneFlowcharts() {
            try {
                URL url = this.getClass().getResource("/client/data/help/flowcharts-help.html");
                this.setPage(url);
                this.setEditable(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class EditorPaneEquations
    extends JEditorPane {
        public EditorPaneEquations() {
            try {
                URL url = this.getClass().getResource("/client/data/help/equations-help.html");
                this.setPage(url);
                this.setEditable(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class PnlButton
    extends JPanel {
        private boolean isHover = false;
        private boolean isCrn = false;
        private Font font = new Font("Arial", 1, 12);
        private String title;
        private int width;
        private int height;
        private float[] dash1 = new float[]{4.0f};
        private BasicStroke dashed = new BasicStroke(1.3f, 0, 0, 1.0f, this.dash1, 0.0f);
        private RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

        public PnlButton(String title, int width, int height) {
            this.title = title;
            this.width = width;
            this.height = height;
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setPreferredSize(new Dimension(width, height));
            URL icourl = this.getClass().getResource("/client/ui/images/arrow-button-ico.png");
            Image imgIco = FrmHelp.this.tk.getImage(icourl);
            JLabel lblIco = new JLabel(new ImageIcon(imgIco));
            lblIco.setPreferredSize(new Dimension(height, height));
            this.add(lblIco);
            JLabel lblTitle = new JLabel(title);
            lblTitle.setFont(this.font);
            lblTitle.setPreferredSize(new Dimension(width - height, height));
            this.add(lblTitle);
        }

        public void setHover(boolean isHover) {
            this.isHover = isHover;
            this.updateUI();
        }

        public void setCrn(boolean isCrn) {
            this.isCrn = isCrn;
            this.updateUI();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHints(this.rh);
            g2d.setStroke(this.dashed);
            if (this.isHover || this.isCrn) {
                FontMetrics metrics = g2d.getFontMetrics(this.font);
                int strWidth = metrics.stringWidth(this.title);
                g2d.drawLine(this.height, 27, this.height + strWidth, 27);
            }
        }
    }
}

