/*
 * Decompiled with CFR 0.152.
 */
package client.ui;

import client.data.SolutionScenario;
import client.ui.DlgAbout;
import client.ui.DlgCalculations;
import client.ui.DlgLoadExample;
import client.ui.FrmHelp;
import client.ui.PnlSolutionPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FrmMain
extends JFrame
implements MouseListener {
    private PnlSolutionPath pnlSolutionPath;
    private DlgLoadExample dlgLoadExample = null;
    private DlgAbout dlgAbout = null;
    public DlgCalculations dlgCalculations = null;
    private Toolkit tk = this.getToolkit();
    private PnlButton btnHelp;
    private PnlButton lblAbout;
    private JPanel pnlFooterContainer;

    public FrmMain() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel pane = (JPanel)this.getContentPane();
        pane.setLayout(gbl);
        pane.setPreferredSize(new Dimension(1000, 690));
        this.setTitle("Visual Equation Solver v1.1");
        URL icourl = this.getClass().getResource("/client/ui/images/logo-ico.png");
        Image imgLogoIco = this.tk.getImage(icourl);
        this.setIconImage(imgLogoIco);
        this.dlgCalculations = new DlgCalculations(this, "\u03a0\u03c1\u03bf\u03b2\u03bf\u03bb\u03ae \u03a5\u03c0\u03bf\u03bb\u03bf\u03b3\u03b9\u03c3\u03bc\u03ce\u03bd", true);
        this.dlgCalculations.setVisible(false);
        JPanel pnlTopContainer = new JPanel(gbl);
        pnlTopContainer.setMinimumSize(new Dimension(1000, 70));
        pnlTopContainer.setPreferredSize(new Dimension(1000, 70));
        pnlTopContainer.setBackground(new Color(209, 200, 188));
        JPanel pnlLogoContainer = new JPanel(new FlowLayout(0, 0, 0));
        pnlLogoContainer.setPreferredSize(new Dimension(400, 70));
        pnlLogoContainer.setMinimumSize(new Dimension(400, 70));
        pnlLogoContainer.setOpaque(false);
        pnlLogoContainer.setBackground(Color.blue);
        URL logourl = this.getClass().getResource("/client/ui/images/logo.png");
        Image imgLogo = this.tk.getImage(logourl);
        JLabel lblLogo = new JLabel(new ImageIcon(imgLogo));
        lblLogo.setPreferredSize(new Dimension(300, 70));
        pnlLogoContainer.add(lblLogo);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbl.setConstraints(pnlLogoContainer, gbc);
        pnlTopContainer.add(pnlLogoContainer);
        JPanel pnlSpace = new JPanel(new FlowLayout(0, 0, 0));
        pnlSpace.setPreferredSize(new Dimension(100, 70));
        pnlSpace.setMinimumSize(new Dimension(100, 70));
        pnlSpace.setOpaque(false);
        pnlSpace.setBackground(Color.red);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbl.setConstraints(pnlSpace, gbc);
        pnlTopContainer.add(pnlSpace);
        JPanel pnlTopControlsContainer = new JPanel(new FlowLayout(2, 0, 0));
        pnlTopControlsContainer.setPreferredSize(new Dimension(500, 70));
        pnlTopControlsContainer.setMinimumSize(new Dimension(500, 70));
        pnlTopControlsContainer.setOpaque(false);
        JPanel pnlContainer = new JPanel(new FlowLayout(0, 0, 0)){
            private float[] dash1;
            private BasicStroke dashed;
            private BasicStroke line;
            private RenderingHints rh;
            {
                this.dash1 = new float[]{5.0f};
                this.dashed = new BasicStroke(2.0f, 0, 0, 10.0f, this.dash1, 0.0f);
                this.line = new BasicStroke(2.0f, 0, 0);
                this.rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHints(this.rh);
                g2d.setStroke(this.dashed);
                g2d.setColor(new Color(35, 43, 46));
                g2d.drawLine(75, 70, 95, 35);
                g2d.drawLine(95, 35, 300, 35);
            }
        };
        pnlContainer.setPreferredSize(new Dimension(300, 70));
        pnlContainer.setBackground(Color.red);
        pnlContainer.setOpaque(false);
        pnlSpace = new JPanel(new FlowLayout(0, 0, 0));
        pnlSpace.setPreferredSize(new Dimension(300, 40));
        pnlSpace.setBackground(Color.green);
        pnlSpace.setOpaque(false);
        pnlContainer.add(pnlSpace);
        JPanel pnlButtons = new JPanel(new FlowLayout(2, 0, 0));
        pnlButtons.setPreferredSize(new Dimension(300, 30));
        pnlButtons.setBackground(Color.pink);
        pnlButtons.setOpaque(false);
        this.btnHelp = new PnlButton("\u0392\u03bf\u03ae\u03b8\u03b5\u03b9\u03b1", 100, 30);
        this.btnHelp.addMouseListener(this);
        this.btnHelp.setOpaque(false);
        pnlButtons.add(this.btnHelp);
        this.lblAbout = new PnlButton("\u03a3\u03c7\u03b5\u03c4\u03b9\u03ba\u03ac", 100, 30);
        this.lblAbout.addMouseListener(this);
        this.lblAbout.setOpaque(false);
        pnlButtons.add(this.lblAbout);
        pnlContainer.add(pnlButtons);
        pnlTopControlsContainer.add(pnlContainer);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbl.setConstraints(pnlTopControlsContainer, gbc);
        pnlTopContainer.add(pnlTopControlsContainer);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbl.setConstraints(pnlTopContainer, gbc);
        pane.add(pnlTopContainer);
        JPanel pnlHorLine = new JPanel(new FlowLayout(0, 0, 0));
        pnlHorLine.setMinimumSize(new Dimension(100, 3));
        pnlHorLine.setPreferredSize(new Dimension(100, 3));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        pnlHorLine.setBackground(new Color(35, 43, 46));
        gbl.setConstraints(pnlHorLine, gbc);
        pane.add(pnlHorLine);
        JScrollPane pnlScroll = new JScrollPane(20, 30);
        pnlScroll.setMinimumSize(new Dimension(100, 100));
        pnlScroll.setPreferredSize(new Dimension(100, 100));
        this.pnlSolutionPath = new PnlSolutionPath(this, this);
        pnlScroll.getViewport().add(this.pnlSolutionPath);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        pnlScroll.setBackground(new Color(235, 230, 224));
        gbl.setConstraints(pnlScroll, gbc);
        pane.add(pnlScroll);
        pnlHorLine = new JPanel(new FlowLayout(0, 0, 0));
        pnlHorLine.setMinimumSize(new Dimension(100, 2));
        pnlHorLine.setPreferredSize(new Dimension(100, 2));
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        pnlHorLine.setBackground(new Color(35, 43, 46));
        gbl.setConstraints(pnlHorLine, gbc);
        pane.add(pnlHorLine);
        pnlHorLine = new JPanel(new FlowLayout(0, 0, 0));
        pnlHorLine.setMinimumSize(new Dimension(100, 2));
        pnlHorLine.setPreferredSize(new Dimension(100, 2));
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        pnlHorLine.setBackground(new Color(235, 230, 224));
        gbl.setConstraints(pnlHorLine, gbc);
        pane.add(pnlHorLine);
        pnlHorLine = new JPanel(new FlowLayout(0, 0, 0));
        pnlHorLine.setMinimumSize(new Dimension(100, 1));
        pnlHorLine.setPreferredSize(new Dimension(100, 1));
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        pnlHorLine.setBackground(new Color(35, 43, 46));
        gbl.setConstraints(pnlHorLine, gbc);
        pane.add(pnlHorLine);
        this.pnlFooterContainer = new JPanel(gbl);
        this.pnlFooterContainer.setMinimumSize(new Dimension(100, 35));
        this.pnlFooterContainer.setPreferredSize(new Dimension(1000, 35));
        this.pnlFooterContainer.setBackground(new Color(209, 200, 188));
        this.pnlFooterContainer.addMouseListener(this);
        JPanel pnlLeft = new JPanel(gbl);
        pnlLeft.setPreferredSize(new Dimension(430, 35));
        pnlLeft.setMinimumSize(new Dimension(430, 35));
        pnlLeft.setBackground(Color.pink);
        pnlLeft.setOpaque(false);
        pnlSpace = new JPanel(new FlowLayout(0, 0, 0));
        pnlSpace.setPreferredSize(new Dimension(5, 35));
        pnlSpace.setMinimumSize(new Dimension(5, 35));
        pnlSpace.setOpaque(false);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbl.setConstraints(pnlSpace, gbc);
        pnlLeft.add(pnlSpace);
        URL aurl = this.getClass().getResource("/client/ui/images/logo-helcol-footer.png");
        Image imgHelcolFooter = this.tk.getImage(aurl);
        JLabel lblHelcolLogo = new JLabel(new ImageIcon(imgHelcolFooter));
        lblHelcolLogo.setPreferredSize(new Dimension(35, 35));
        lblHelcolLogo.setMinimumSize(new Dimension(35, 35));
        lblHelcolLogo.setHorizontalAlignment(0);
        lblHelcolLogo.setVerticalAlignment(0);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbl.setConstraints(lblHelcolLogo, gbc);
        pnlLeft.add(lblHelcolLogo);
        pnlSpace = new JPanel(new FlowLayout(0, 0, 0));
        pnlSpace.setPreferredSize(new Dimension(5, 35));
        pnlSpace.setMinimumSize(new Dimension(5, 35));
        pnlSpace.setOpaque(false);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbl.setConstraints(pnlSpace, gbc);
        pnlLeft.add(pnlSpace);
        JPanel pnlCon = new JPanel(new FlowLayout(0, 0, 0));
        pnlCon.setPreferredSize(new Dimension(400, 35));
        pnlCon.setMinimumSize(new Dimension(400, 35));
        pnlCon.setOpaque(false);
        pnlSpace = new JPanel(new FlowLayout(0, 0, 0));
        pnlSpace.setPreferredSize(new Dimension(400, 2));
        pnlSpace.setOpaque(false);
        pnlCon.add(pnlSpace);
        JLabel lblHelcol = new JLabel("\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03cc \u039a\u03bf\u03bb\u03bb\u03ad\u03b3\u03b9\u03bf \u0398\u03b5\u03c3\u03c3\u03b1\u03bb\u03bf\u03bd\u03af\u03ba\u03b7\u03c2 - www.hellenic-college.gr");
        lblHelcol.setForeground(new Color(35, 43, 46));
        lblHelcol.setPreferredSize(new Dimension(400, 15));
        lblHelcol.setFont(new Font("Tahoma", 3, 11));
        pnlCon.add(lblHelcol);
        lblHelcol = new JLabel("\u03a0\u03c1\u03bf\u03c3\u03c7\u03bf\u03bb\u03b9\u03ba\u03ae \u0391\u03b3\u03c9\u03b3\u03ae - \u039d\u03b7\u03c0\u03b9\u03b1\u03b3\u03c9\u03b3\u03b5\u03af\u03bf - \u0394\u03b7\u03bc\u03bf\u03c4\u03b9\u03ba\u03cc - \u0393\u03c5\u03bc\u03bd\u03ac\u03c3\u03b9\u03bf - \u039b\u03cd\u03ba\u03b5\u03b9\u03bf");
        lblHelcol.setForeground(new Color(35, 43, 46));
        lblHelcol.setPreferredSize(new Dimension(400, 15));
        lblHelcol.setFont(new Font("Tahoma", 3, 11));
        pnlCon.add(lblHelcol);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbl.setConstraints(pnlCon, gbc);
        pnlLeft.add(pnlCon);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbl.setConstraints(pnlLeft, gbc);
        this.pnlFooterContainer.add(pnlLeft);
        JPanel pnlCenter = new JPanel(gbl);
        pnlCenter.setPreferredSize(new Dimension(40, 35));
        pnlCenter.setMinimumSize(new Dimension(40, 35));
        pnlCenter.setBackground(Color.green);
        pnlCenter.setOpaque(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbl.setConstraints(pnlCenter, gbc);
        this.pnlFooterContainer.add(pnlCenter);
        JPanel pnlRight = new JPanel(new FlowLayout(2, 0, 0));
        pnlRight.setPreferredSize(new Dimension(530, 35));
        pnlRight.setMinimumSize(new Dimension(530, 35));
        pnlRight.setOpaque(false);
        pnlSpace = new JPanel(new FlowLayout(0, 0, 0));
        pnlSpace.setPreferredSize(new Dimension(520, 2));
        pnlSpace.setOpaque(false);
        pnlRight.add(pnlSpace);
        JPanel pnlRightTop = new JPanel(new FlowLayout(0, 0, 0));
        pnlRightTop.setPreferredSize(new Dimension(520, 15));
        pnlRightTop.setBackground(Color.gray);
        pnlRightTop.setOpaque(false);
        JLabel lbl = new JLabel("\u03a3\u03c5\u03bd\u03c4\u03b5\u03bb\u03b5\u03c3\u03c4\u03ad\u03c2 :    ");
        lbl.setHorizontalAlignment(4);
        lbl.setFont(new Font("Tahoma", 3, 11));
        lbl.setPreferredSize(new Dimension(100, 15));
        lbl.setForeground(new Color(35, 43, 46));
        pnlRightTop.add(lbl);
        lbl = new JLabel("\u039a\u03c9\u03bd\u03c3\u03c4\u03b1\u03bd\u03c4\u03af\u03bd\u03bf\u03c2 \u03a0\u03b1\u03c1\u03b1\u03c3\u03ba\u03b5\u03c5\u03cc\u03c0\u03bf\u03c5\u03bb\u03bf\u03c2, \u039a\u03b1\u03b8\u03b7\u03b3\u03b7\u03c4\u03ae\u03c2 \u03a0\u03bb\u03b7\u03c1\u03bf\u03c6\u03bf\u03c1\u03b9\u03ba\u03ae\u03c2, \u03a0\u039519, MSc");
        lbl.setFont(new Font("Tahoma", 3, 11));
        lbl.setPreferredSize(new Dimension(420, 15));
        lbl.setForeground(new Color(35, 43, 46));
        pnlRightTop.add(lbl);
        pnlRight.add(pnlRightTop);
        JPanel pnlRightBottom = new JPanel(new FlowLayout(0, 0, 0));
        pnlRightBottom.setPreferredSize(new Dimension(520, 15));
        pnlRightBottom.setBackground(Color.darkGray);
        pnlRightBottom.setOpaque(false);
        lbl = new JLabel("");
        lbl.setFont(new Font("Tahoma", 1, 11));
        lbl.setPreferredSize(new Dimension(100, 15));
        pnlRightBottom.add(lbl);
        lbl = new JLabel("\u03a6\u03ce\u03c4\u03b9\u03bf\u03c2 \u039a\u03b1\u03c1\u03b1\u03b3\u03b9\u03ce\u03c1\u03b3\u03bf\u03c2, \u039a\u03b1\u03b8\u03b7\u03b3\u03b7\u03c4\u03ae\u03c2 \u039c\u03b1\u03b8\u03b7\u03bc\u03b1\u03c4\u03b9\u03ba\u03ce\u03bd, \u03a0\u039503");
        lbl.setFont(new Font("Tahoma", 3, 11));
        lbl.setPreferredSize(new Dimension(420, 15));
        lbl.setForeground(new Color(35, 43, 46));
        pnlRightBottom.add(lbl);
        pnlRight.add(pnlRightBottom);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbl.setConstraints(pnlRight, gbc);
        this.pnlFooterContainer.add(pnlRight);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbl.setConstraints(this.pnlFooterContainer, gbc);
        pane.add(this.pnlFooterContainer);
        this.pack();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object src = e.getSource();
        if (src.equals(this.lblAbout)) {
            this.lblAbout.setHover(false);
        } else if (src.equals(this.btnHelp)) {
            this.btnHelp.setHover(false);
        } else if (src.equals(this.pnlFooterContainer)) {
            this.pnlFooterContainer.setBackground(new Color(209, 200, 188));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object src = e.getSource();
        if (src.equals(this.lblAbout)) {
            this.lblAbout.setHover(true);
        } else if (src.equals(this.btnHelp)) {
            this.btnHelp.setHover(true);
        } else if (src.equals(this.pnlFooterContainer)) {
            this.pnlFooterContainer.setBackground(new Color(235, 230, 224));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object src = e.getSource();
        if (src.equals(this.pnlSolutionPath.pnlParametersInput.lblRun)) {
            this.pnlSolutionPath.setAllNotActive();
            this.dlgCalculations.clearAll();
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;
            boolean aok = true;
            boolean bok = true;
            boolean cok = true;
            try {
                a = Double.parseDouble(this.pnlSolutionPath.pnlParametersInput.txtA.getText());
            }
            catch (NumberFormatException nfe) {
                aok = false;
            }
            try {
                b = Double.parseDouble(this.pnlSolutionPath.pnlParametersInput.txtB.getText());
            }
            catch (NumberFormatException nfe) {
                bok = false;
            }
            try {
                c = Double.parseDouble(this.pnlSolutionPath.pnlParametersInput.txtC.getText());
            }
            catch (NumberFormatException nfe) {
                cok = false;
            }
            if (aok && bok && cok) {
                SolutionScenario solScenario = new SolutionScenario(a, b, c);
                solScenario.runCalculations(this.pnlSolutionPath);
            } else {
                String message = "";
                if (!aok) {
                    message = message + "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1 \u03c3\u03c4\u03b7 \u03bc\u03bf\u03c1\u03c6\u03bf\u03c0\u03bf\u03af\u03b7\u03c3\u03b7 \u03c4\u03bf\u03c5 \u03b1\u03c1\u03b9\u03b8\u03bc\u03bf\u03c5 \u03b1" + "\n";
                }
                if (!bok) {
                    message = message + "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1 \u03c3\u03c4\u03b7 \u03bc\u03bf\u03c1\u03c6\u03bf\u03c0\u03bf\u03af\u03b7\u03c3\u03b7 \u03c4\u03bf\u03c5 \u03b1\u03c1\u03b9\u03b8\u03bc\u03bf\u03c5 \u03b2" + "\n";
                }
                if (!cok) {
                    message = message + "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1 \u03c3\u03c4\u03b7 \u03bc\u03bf\u03c1\u03c6\u03bf\u03c0\u03bf\u03af\u03b7\u03c3\u03b7 \u03c4\u03bf\u03c5 \u03b1\u03c1\u03b9\u03b8\u03bc\u03bf\u03c5 \u03b3" + "\n";
                }
                JOptionPane.showMessageDialog(this, message, "\u03a3\u03c6\u03ac\u03bb\u03bc\u03b1", 0);
            }
        } else if (src.equals(this.pnlSolutionPath.pnlParametersInput.lblClear)) {
            this.pnlSolutionPath.pnlParametersInput.txtA.setText("");
            this.pnlSolutionPath.pnlParametersInput.txtB.setText("");
            this.pnlSolutionPath.pnlParametersInput.txtC.setText("");
            this.pnlSolutionPath.setAllNotActive();
        } else if (src.equals(this.pnlSolutionPath.pnlParametersInput.lblExample)) {
            this.dlgLoadExample = new DlgLoadExample((Frame)this, "\u0391\u03bd\u03c4\u03b9\u03c0\u03c1\u03bf\u03c3\u03c9\u03c0\u03b5\u03c5\u03c4\u03b9\u03ba\u03ac \u03a0\u03b1\u03c1\u03b1\u03b4\u03b5\u03af\u03b3\u03bc\u03b1\u03c4\u03b1", true, this);
            this.dlgLoadExample.setLocation((int)this.getLocation().getX() + this.getWidth() / 2 - this.dlgLoadExample.getWidth() / 2, (int)this.getLocation().getY() + this.getHeight() / 2 - this.dlgLoadExample.getHeight() / 2);
            this.dlgLoadExample.setVisible(true);
        } else if (src.equals(this.pnlSolutionPath.pnlParametersInput.lblCalculations)) {
            this.dlgCalculations.setLocation((int)this.getLocation().getX() + this.getWidth() / 2 - this.dlgCalculations.getWidth() / 2, (int)this.getLocation().getY() + this.getHeight() / 2 - this.dlgCalculations.getHeight() / 2);
            this.dlgCalculations.setVisible(true);
        } else if (src.equals(this.pnlFooterContainer)) {
            this.dlgAbout = new DlgAbout(this, "\u03a3\u03c7\u03b5\u03c4\u03b9\u03ba\u03ac \u03bc\u03b5 \u03c4\u03b7\u03bd \u03b5\u03c6\u03b1\u03c1\u03bc\u03bf\u03b3\u03ae", true);
            this.dlgAbout.setLocation((int)this.getLocation().getX() + this.getWidth() / 2 - this.dlgAbout.getWidth() / 2, (int)this.getLocation().getY() + this.getHeight() / 2 - this.dlgAbout.getHeight() / 2);
            this.dlgAbout.setVisible(true);
        } else if (src.equals(this.lblAbout)) {
            this.dlgAbout = new DlgAbout(this, "\u03a3\u03c7\u03b5\u03c4\u03b9\u03ba\u03ac \u03bc\u03b5 \u03c4\u03b7\u03bd \u03b5\u03c6\u03b1\u03c1\u03bc\u03bf\u03b3\u03ae", true);
            this.dlgAbout.setLocation((int)this.getLocation().getX() + this.getWidth() / 2 - this.dlgAbout.getWidth() / 2, (int)this.getLocation().getY() + this.getHeight() / 2 - this.dlgAbout.getHeight() / 2);
            this.dlgAbout.setVisible(true);
        } else if (src.equals(this.btnHelp)) {
            FrmHelp frmHelp = new FrmHelp();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = frmHelp.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            frmHelp.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            frmHelp.setVisible(true);
        } else if (src.equals(this.dlgLoadExample.btnOk)) {
            if (this.dlgLoadExample.getSelectedExample() == 1) {
                this.pnlSolutionPath.pnlParametersInput.txtA.setText("1");
                this.pnlSolutionPath.pnlParametersInput.txtB.setText("-5");
                this.pnlSolutionPath.pnlParametersInput.txtC.setText("6");
            } else if (this.dlgLoadExample.getSelectedExample() == 2) {
                this.pnlSolutionPath.pnlParametersInput.txtA.setText("9");
                this.pnlSolutionPath.pnlParametersInput.txtB.setText("-12");
                this.pnlSolutionPath.pnlParametersInput.txtC.setText("4");
            } else if (this.dlgLoadExample.getSelectedExample() == 3) {
                this.pnlSolutionPath.pnlParametersInput.txtA.setText("-1");
                this.pnlSolutionPath.pnlParametersInput.txtB.setText("2");
                this.pnlSolutionPath.pnlParametersInput.txtC.setText("-5");
            } else if (this.dlgLoadExample.getSelectedExample() == 4) {
                this.pnlSolutionPath.pnlParametersInput.txtA.setText("0");
                this.pnlSolutionPath.pnlParametersInput.txtB.setText("3");
                this.pnlSolutionPath.pnlParametersInput.txtC.setText("7");
            } else if (this.dlgLoadExample.getSelectedExample() == 5) {
                this.pnlSolutionPath.pnlParametersInput.txtA.setText("0");
                this.pnlSolutionPath.pnlParametersInput.txtB.setText("0");
                this.pnlSolutionPath.pnlParametersInput.txtC.setText("-8");
            } else if (this.dlgLoadExample.getSelectedExample() == 6) {
                this.pnlSolutionPath.pnlParametersInput.txtA.setText("0");
                this.pnlSolutionPath.pnlParametersInput.txtB.setText("0");
                this.pnlSolutionPath.pnlParametersInput.txtC.setText("0");
            }
            this.dlgLoadExample.setVisible(false);
            this.dlgLoadExample = null;
        } else if (src.equals(this.dlgLoadExample.btnCancel)) {
            this.dlgLoadExample.setVisible(false);
            this.dlgLoadExample = null;
        }
    }

    class PnlButton
    extends JPanel {
        private boolean isHover = false;
        private boolean isCrn = false;
        private Font font = new Font("Arial", 1, 14);
        private String title;
        private int width;
        private int height;
        private float[] dash1 = new float[]{4.0f};
        private BasicStroke dashed = new BasicStroke(1.3f, 0, 0, 1.0f, this.dash1, 0.0f);
        private RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

        public PnlButton(String title, int width, int height) {
            this.title = title;
            this.width = width;
            this.height = height;
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setPreferredSize(new Dimension(width, height));
            JLabel lblTitle = new JLabel(title);
            lblTitle.setFont(this.font);
            lblTitle.setHorizontalAlignment(0);
            lblTitle.setPreferredSize(new Dimension(width, height));
            this.add(lblTitle);
        }

        public void setHover(boolean isHover) {
            this.isHover = isHover;
            this.updateUI();
        }

        public void setCrn(boolean isCrn) {
            this.isCrn = isCrn;
            this.updateUI();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHints(this.rh);
            g2d.setStroke(this.dashed);
            if (this.isHover || this.isCrn) {
                FontMetrics metrics = g2d.getFontMetrics(this.font);
                int strWidth = metrics.stringWidth(this.title);
                g2d.drawLine(this.width / 2 - strWidth / 2 - 3, 25, this.width / 2 - strWidth / 2 + strWidth + 3, 25);
            }
        }
    }
}

